//=============================================================================
// RPGツクールMZ - CharaInBed.js
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc キャラクターをベッドINさせるために縦方向の表示を少しずらします。
 * @author emoriiin979
 *
 * @help CharaInBed.js
 *
 * 対象イベントのY座標を24ピクセル上にずらすことで、
 * いい感じにベッドINさせることができます。
 *
 * - 使用方法 -
 * イベントのメモ欄に<bedIn>を記載してください。
 */

(() => {
    "use strict";

    //-------------------------------------------------------------------------
    // Game_Event

    const _Game_Event_initMembers = Game_Event.prototype.initMembers;
    Game_Event.prototype.initMembers = function() {
        _Game_Event_initMembers.call(this);
        this._inBed = false;
    };

    const _Game_Event_setupPageSettings = Game_Event.prototype.setupPageSettings;
    Game_Event.prototype.setupPageSettings = function() {
        _Game_Event_setupPageSettings.call(this);
        this.setupInBed();
    };

    Game_Event.prototype.setupInBed = function() {
        const pattern = /<bedIn>/i;
        this._inBed = this.event().note.match(pattern);
    };

    const _Game_Event_shiftY = Game_Event.prototype.shiftY;
    Game_Event.prototype.shiftY = function() {
        return this._inBed ? 24 : _Game_Event_shiftY.call(this);
    };
})();
